<?php
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Collect and sanitize input data
    $name = strip_tags(trim($_POST["name"]));
    $email = filter_var(trim($_POST["email"]), FILTER_SANITIZE_EMAIL);
    $phone = strip_tags(trim($_POST["phone"]));
    $date = strip_tags(trim($_POST["date"]));
    $message = trim($_POST["message"]);

    // Validate inputs
    if (empty($name) || empty($message) || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
        // Handle error - redirect back with error or just stop
        header("Location: contact.html?error=invalid_input");
        exit;
    }

    // Email Configuration
    $recipient = "Massiveevents.ng@gmail.com";
    $subject = "New Inquiry from $name - Massive Events Website";

    // Build the email content
    $email_content = "Name: $name\n";
    $email_content .= "Email: $email\n";
    $email_content .= "Phone: $phone\n";
    $email_content .= "Event Date: $date\n\n";
    $email_content .= "Message:\n$message\n";

    // Build the email headers
    // FIX: Send FROM the domain itself (or a generic address) to avoid SPF blocking
    // Use Reply-To so the recipient can reply to the customer
    $email_headers = "From: inquiries@massiveevents.ca\r\n";
    $email_headers .= "Reply-To: $name <$email>\r\n";
    $email_headers .= "X-Mailer: PHP/" . phpversion();

    // Send the email
    if (mail($recipient, $subject, $email_content, $email_headers)) {
        // Redirect to the contact page with success=true (triggers the modal)
        header("Location: contact.html?success=true");
    } else {
        // Redirect with error (optional handling)
        header("Location: contact.html?error=send_failed");
    }
} else {
    // severe accidental access
    header("Location: contact.html");
}
?>